/*
 * Decompiled with CFR 0.152.
 */
package com.alertnow.jenniferAdapter.model;

import com.aries.extension.util.LogUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebHookModel {
    private TreeSet<String> webHookUrlSet = null;

    public WebHookModel(List<Map<String, String>> infoList) {
        this.setWebhookModel(infoList);
    }

    private void setWebhookModel(List<Map<String, String>> infoList) {
        try {
            LogUtil.info((String)"Set setWebhookModel");
            this.initWebHookUrl();
            if (this.webHookUrlSet == null) {
                // empty if block
            }
            for (Map<String, String> m : infoList) {
                Set<String> keySet = m.keySet();
                Iterator<String> itr = keySet.iterator();
                while (itr.hasNext()) {
                    String key = itr.next().toString();
                    String val = m.get(key).toString();
                    if (!this.checkUrlPatten(val)) continue;
                    this.webHookUrlSet.add(val);
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)("Error Message : " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public TreeSet<String> getWebHookUrl() {
        return this.webHookUrlSet;
    }

    private void initWebHookUrl() {
        this.webHookUrlSet = new TreeSet();
    }

    private boolean checkUrlPatten(String val) {
        try {
            String regex = "^(https?):\\/\\/([^:\\/\\s]+)(:([^\\/]*))?((\\/[^\\s/\\/]+)*)?\\/([^#\\s\\?]*)(\\?([^#\\s]*))?(#(\\w*))?$";
            Pattern pattern = Pattern.compile(regex);
            if (pattern.matcher(val).matches()) {
                return true;
            }
        }
        catch (Exception e) {
            LogUtil.error((String)("Error Message : " + e.getMessage()));
            e.printStackTrace();
        }
        return false;
    }
}

